% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_score_scale}
\alias{umx_score_scale}
\title{Score a psychometric scale by summing normal and reversed items}
\usage{
umx_score_scale(
  base = NULL,
  pos = NULL,
  rev = NULL,
  min = 1,
  max = NULL,
  data = NULL,
  score = c("totals", "mean", "max"),
  name = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{base}{String common to all item names.}

\item{pos}{The positive-scored item numbers.}

\item{rev}{The reverse-scored item numbers.}

\item{min}{Min possible score (default = 1). Not implemented for values other than 1 so far...}

\item{max}{Max possible score for an item (to compute how to reverse items).}

\item{data}{The data frame}

\item{score}{Whether to compute the score totals, mean, or max (default = "totals")}

\item{name}{= name of the scale to be returned. Defaults to "base_score"}

\item{na.rm}{Whether to delete NAs when computing scores (Default = TRUE) Note: Choice affects mean!}
}
\value{
\itemize{
\item scores
}
}
\description{
Use this function to generate scores as the appropriate sum of responses to the normal and reversed items in a scale.

Items must be named on the pattern \<base\>\<n\>, where \code{base} is the string common to all item (column) names.
\code{pos} and \code{rev} are vectors of the item numbers for the normal and reverse-scored item numbers.
To reverse items, the function uses \code{itemMax} is the high score (to compute how to reverse items).
\code{min} defaults to 1.
}
\examples{
library(psych)

# ==============================
# = Score Agreeableness totals =
# ==============================

tmp = umx_score_scale("A", pos = 2:5, rev = 1, max = 6, data= bfi, name = "A")
tmp[1, namez(tmp, "A",ignore.case=FALSE)]
#  A1 A2 A3 A4 A5  A
#  2  4  3  4  4  20

# Handscore subject 1
# A2 + A3 + A4 + A5 + A1(Reversed)
# 4  + 3  + 4  + 4 + (6+1)-2 = 20

tmp = umx_score_scale("A", pos = 2:5, rev = 1, max = 6, data= bfi, name = "A", score="mean")
tmp$A[1] # subject 1 mean = 4

tmp = umx_score_scale("A", pos = 2:5, rev = 1, max = 6, data= bfi, name = "A", score="max")
tmp$A[1] # subject 1 max = 5 (the reversed item 1)

tmp = umx_score_scale("E", pos = c(3,4,5), rev = c(1,2), max = 6, data= tmp)
tmp$E_score[1] # default scale name

# Using @BillRevelle's psych package: More diagnostics, including alpha
scores= psych::scoreItems(items = bfi, min = 1, max = 6, keys = list(
	E = c("-E1","-E2", "E3", "E4", "E5"),
	A = c("-A1", "A2", "A3", "A4", "A5")
))
summary(scores)
scores$scores[1,]
#  E   A 
# 3.8 4.0 

# Compare output
# (note, by default psych::scoreItems replaces NAs with the sample median...)
RevelleE = as.numeric(scores$scores[,"E"]) * 5
all(RevelleE == tmp[,"E_score"], na.rm = TRUE)

}
\seealso{
Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}()},
  \code{\link{qm}()}, \code{\link{umxBrownie}()},
  \code{\link{umxLav2RAM}()}, \code{\link{umxRAM2Lav}()},
  \code{\link{umxVersion}()},
  \code{\link{umx_array_shift}()},
  \code{\link{umx_find_object}()}, \code{\link{umx_msg}()},
  \code{\link{umx_open_CRAN_page}()},
  \code{\link{umx_pad}()}, \code{\link{umx_print}()},
  \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
