% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_has_means}
\alias{umx_has_means}
\title{umx_has_means}
\usage{
umx_has_means(model)
}
\arguments{
\item{model}{The \code{\link[=mxModel]{mxModel()}} to check for presence of means}
}
\value{
\itemize{
\item TRUE or FALSE
}
}
\description{
A utility function to return a binary answer to the question "does this \code{\link[=mxModel]{mxModel()}} have a means model?"
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("has_means_ex", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)#'
umx_has_means(m1)
m1 = mxModel(m1,
	mxPath(from = "one", to = manifests),
	mxData(demoOneFactor[1:100,], type = "raw")
)
umx_has_means(m1)
m1 = mxRun(m1)
umx_has_means(m1)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Test: 
\code{\link{umx_check_OS}()},
\code{\link{umx_check_model}()},
\code{\link{umx_check_names}()},
\code{\link{umx_check_parallel}()},
\code{\link{umx_check}()},
\code{\link{umx_has_CIs}()},
\code{\link{umx_has_been_run}()},
\code{\link{umx_has_square_brackets}()},
\code{\link{umx_is_MxData}()},
\code{\link{umx_is_MxMatrix}()},
\code{\link{umx_is_MxModel}()},
\code{\link{umx_is_RAM}()},
\code{\link{umx_is_cov}()}
}
\concept{Test}
