% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxGxEbiv.R
\name{umxGxEbiv}
\alias{umxGxEbiv}
\title{Purcell (2002) Bivariate GxE model: Suitable when twins differ on the moderator.}
\usage{
umxGxEbiv(
  name = "GxEbiv",
  selDVs,
  selDefs,
  dzData,
  mzData,
  sep = NULL,
  lboundACE = NA,
  lboundM = NA,
  dropMissingDef = FALSE,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{name}{The name of the model (defaults to "GxEbiv")}

\item{selDVs}{The dependent variable (e.g. IQ)}

\item{selDefs}{The definition variable (e.g. socioeconomic status)}

\item{dzData}{The DZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{mzData}{The MZ dataframe containing the Twin 1 and Twin 2 DV and moderator (4 columns)}

\item{sep}{Expand variable base names, i.e., "_T" makes var -> var_T1 and var_T2}

\item{lboundACE}{If !NA, then lbound the main effects at this value (default = NA)}

\item{lboundM}{If !NA, then lbound the moderators at this value (default = NA)}

\item{dropMissingDef}{Whether to automatically drop missing def var rows for the user (gives a warning) default = FALSE}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing)}
}
\value{
\itemize{
\item GxEbiv \code{\link[=mxModel]{mxModel()}}
}
}
\description{
GxE interaction models test the hypothesis that the strength of genetic
and environmental influences vary parametrically across levels of a measured environment.
}
\details{
Whereas univariate \code{\link[=umxGxE]{umxGxE()}} models assume the twins share the moderator,
or have zero correlation on the moderator, \code{\link[=umxGxEbiv]{umxGxEbiv()}} allows testing moderation in
cases where members of a twin pair differ on the moderator, (Purcell, 2002; van der Sluis et al., 2012).

This is the same model we teach at Boulder.

The following figure shows this bivariate GxE model as a path diagram (Twin 1 shown). Whereas
the univariate model incorporates the moderator in the means model, the bivariate model incorporates
the moderator as a first class variable, with its own ACE structure, shared pathways to the trait of interest,
and the ability to moderate both specific and shared A, C, and E, influences on the trait of interest.

\figure{GxEbiv.png}

Twin 1 and twin 2 A, C, and E latent traits are connected in the standard fashion, with the
covariance of the T1 and T2 latent genetic traits set to .5 for DZ and 1.0 for MZ pairs.
For the sake of clarity, C, and E paths are omitted here. These mirror those for A.
}
\examples{
require(umx)
data(twinData)
selDVs  = "wt"
selDefs = "ht"
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), sep = "")
mzData  = subset(df, zygosity \%in\%  c("MZFF", "MZMM"))
dzData  = subset(df, zygosity \%in\%  c("DZFF", "DZMM", "DZOS"))

\dontrun{
m1 = umxGxEbiv(selDVs = selDVs, selDefs = selDefs, 
	dzData = dzData, mzData = mzData, sep = "", dropMissingDef = TRUE)

# Plot Moderation
umxSummaryGxEbiv(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = FALSE)
m2 = umxModify(m1, update = c("cBeta2_r1c1", "eBeta1_r1c1", "eBeta2_r1c1"), comparison = TRUE)
#
# TODO: teach umxReduce to test all relevant hypotheses for umxGxEbiv
umxReduce(m1)
}
}
\references{
\itemize{
\item Purcell, S. (2002). Variance components models for gene-environment interaction in twin analysis. \emph{Twin Research},
\strong{6}, 554-571. doi:\href{https://doi.org/10.1375/twin.5.6.554}{10.1375/twin.5.6.554}.
\item van der Sluis, S., Posthuma, D., & Dolan, C. V. (2012). A note on false positives and
power in G x E modelling of twin data. \emph{Behavior Genetics},
\strong{42}, 170-186. doi:\href{https://doi.org/10.1007/s10519-011-9480-3}{10.1007/s10519-011-9480-3}.
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}}, \code{\link[=umxReduce]{umxReduce()}}
}

Other Twin Modeling Functions: 
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
