% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxPlotFun}
\alias{umxPlotFun}
\title{Easily plot functions in R}
\usage{
umxPlotFun(
  fun = dnorm,
  min = -1,
  max = 5,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  p = NULL
)
}
\arguments{
\item{fun}{Function to plot. Also takes strings like "sin(x) + sqrt(1/x)"}

\item{min}{x-range min}

\item{max}{x-range max}

\item{xlab}{= Optional x axis label}

\item{ylab}{= Optional y axis label}

\item{title}{Optional title for the plot}

\item{p}{Optional plot onto which to draw the function.}
}
\value{
\itemize{
\item A ggplot graph
}
}
\description{
A wrapper for \code{\link[ggplot2:geom_function]{ggplot2::stat_function()}}
}
\details{
Easily plot a function - like sin, using ggplot.
}
\examples{
\dontrun{
# Uses fonts not available on CRAN
umxPlotFun(sin, max= 2*pi)
umxPlotFun("sqrt(1/x)", max= 2*pi)
umxPlotFun(sin, max= 2*pi, ylab="Output of sin", title="My Big Graph")
p = umxPlotFun(function(x){x^2}, max= 100, title="Supply and demand")
umxPlotFun(function(x){100^2-x^2}, p = p)

# Controlling other plot features
umxPlotFun(c("sin(x)", "x^3")) + ylim(c(-1,5)) 
}

}
\seealso{
\itemize{
\item \code{\link[ggplot2:geom_function]{ggplot2::stat_function()}}
}

Other Plotting functions: 
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umx}}
}
\concept{Plotting functions}
