% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{structuredness}
\alias{structuredness}
\title{Structuredness}
\usage{
structuredness(repetition_and_path_log, xml_internal_doc, signavio = FALSE)
}
\arguments{
\item{repetition_and_path_log}{repetition and path log list object created by the function create_repetition_and_path_log}

\item{xml_internal_doc}{document object created using the create_internal_document function}

\item{signavio}{boolean which indicates whether the file stems from signavio}
}
\value{
an integer indicating the structuredness
}
\description{
Structuredness measures to which extent the process model can be divided into block structured structures (matching gateways)
Calculation: 1 - size of reduced process model / size of normal process model
To get the reduced process model, the following rules are applied:
-removal of trivial constructs (one incoming and one outgoing sequence flow)
-removal of matching gateways (for loops, this means first a join then a split, for all other gateways, it's the other way around)
-loops with other than XOR-gateways and non-matching gateways are kept
-gateways which are the consequence of multiple start or end events are removed
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")
path_log <- create_path_and_repetition_log(create_internal_doc(file_path))}
structuredness(path_log, create_internal_doc(file_path))
}
