#ifndef SIMELLIPSOID_H_
#define SIMELLIPSOID_H_

#define MAX_ITER 100

#include "Intersector.h"

#ifdef __cplusplus
extern "C" {
#endif
 //
 SEXP EllipsoidSystem(SEXP R_param, SEXP R_cond);
 SEXP IntersectSpheroidSystem(SEXP ext, SEXP R_n, SEXP R_z);
 SEXP GetEllipsoidSystem(SEXP ext);
 SEXP SetupSpheroidSystem(SEXP R_vname, SEXP R_env, SEXP R_param, SEXP R_cond);
 //
#ifdef __cplusplus
}
#endif


namespace STGM {

/**
 *  Ellipsoid system
 */
class CEllipsoidSystem
{
 public:
  CSpheroid::spheroid_type m_stype;

  CEllipsoidSystem(CBox3 &box, double lam, CVector3d &mu, CSpheroid::spheroid_type stype)
    :  m_stype(stype), m_box(box), m_lam(lam), m_mu(mu),  num(0)
  {
  };

  void simEllipsoidSys(R_Calldata d);
  void simEllipsoidSysJoint(R_Calldata d);

  STGM::Spheroids &refObjects()  { return m_spheroids; }
  const STGM::Spheroids &refObjects() const { return m_spheroids; }

  inline size_t size()  { return m_spheroids.size(); }

  const STGM::CBox3 &box() const { return m_box; }

  void IntersectWithBox(IntersectorSpheroidPlaneVec &objects);
  void IntersectWithPlane(IntersectorSpheroidPlaneVec &objects, STGM::CPlane &plane);
  void simInfo();

 private:
  CBox3 m_box;

  double m_lam;
  CVector3d m_mu;

  Spheroids m_spheroids;
  size_t num;
};



} /* namespace STGM */

#endif /* SIMELLIPSOID_H_ */
