% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnnoClasses.R
\docType{class}
\name{geneanno-class}
\alias{geneanno}
\alias{geneanno-class}
\title{An S4 class to represent the base information used by the methods.}
\description{
An S4 class to represent the base information used by the methods.
}
\section{Slots}{

\describe{
\item{\code{db}}{A character string stating the NIH/NCBI database to be queried. (Default - "gene")}

\item{\code{nihbase}}{A character string stating the base URL for NIH/NCBI queries.}

\item{\code{ids}}{A Vector of character strings}

\item{\code{uniprotbase}}{A character string stating the base URL for Uniprot queries.}

\item{\code{uniprotquery}}{A character string stating additional information to optimize the query to the Uniport database.}

\item{\code{uniprotcolumns}}{A character string stating the database columns to be returned from the Uniport database.}

\item{\code{genelist}}{A vector of character strings representing a unique list of the genes queried.}

\item{\code{fileroot}}{A charcter string of the directory for file input and storage. (defaults to working directory)}

\item{\code{outputstem}}{A character string stating the sub-directory of 'fileroot' into which output files are saved. (Default - "gene_annotations")}

\item{\code{genefilestem}}{A character string stating the sub-directory of 'fileroot' into which gene objects are saved. (Default - "genes")}

\item{\code{groupnos}}{A numeric vector representing the identifiers of groups in the input file/list.}
}}

