% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ungroup-package.r
\docType{package}
\name{ungroup}
\title{ungroup: Penalized Composite Link Model for Efficient Estimation of 
 Smooth Distributions from Coarsely Binned Data}
\description{
Versatile method for ungrouping histograms (binned count data) 
 assuming that counts are Poisson distributed and that the underlying sequence 
 on a fine grid to be estimated is smooth. The method is based on the composite 
 link model and estimation is achieved by maximizing a penalized likelihood. 
 Smooth detailed sequences of counts and rates are so estimated from the binned 
 counts. Ungrouping binned data can be desirable for many reasons: Bins can be 
 too coarse to allow for accurate analysis; comparisons can be hindered when 
 different grouping approaches are used in different histograms; and the last 
 interval is often wide and open-ended and, thus, covers a lot of information 
 in the tail area. Age-at-death distributions grouped in age classes and 
 abridged life tables are examples of binned data. Because of modest assumptions, 
 the approach is suitable for many demographic and epidemiological applications. 
 For a detailed description of the method and applications see 
 Rizzi et al. (2015) <doi:10.1093/aje/kwv020>.
}
\details{
To learn more about the package, start with the vignettes:
\code{browseVignettes(package = "ungroup")}
\insertNoCite{*}{ungroup}
}
\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mpascariu/ungroup}
  \item Report bugs at \url{https://github.com/mpascariu/ungroup/issues}
}

}
\author{
\strong{Maintainer}: Marius D. Pascariu \email{rpascariu@outlook.com} (\href{https://orcid.org/0000-0002-2568-6489}{ORCID})

Authors:
\itemize{
  \item Silvia Rizzi \email{srizzi@health.sdu.dk}
  \item Jonas Schoeley (\href{https://orcid.org/0000-0002-3340-8518}{ORCID})
  \item Maciej J. Danko \email{Danko@demogr.mpg.de} (\href{https://orcid.org/0000-0002-7924-9022}{ORCID})
}

}
