% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vanderbilt.R
\docType{data}
\name{vanderbilt_2}
\alias{vanderbilt_2}
\title{Neutral colors of Vanderbilt University, USA}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on 
\href{https://brand.vanderbilt.edu/color/}{Vanderbilt's brand style guide}.
}
\usage{
vanderbilt_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{vanderbilt_2} provides the 4 neutral colors
of the \href{https://www.vanderbilt.edu/}{Vanderbilt University}, USA.
}
\details{
The 4 neutral colors are
\code{"vanderbilt_dark_grey"} (defined as HEX #777777),
\code{"vanderbilt_light_gery"} (defined as HEX #E4E4E4),
\code{"vanderbilt_sand"} (defined as HEX #E0D5C0) and 
\code{"vanderbilt_cream"} (defined as HEX #F5F3EF).

\code{vanderbilt_2} uses the HEX color definitions.
}
\examples{
vanderbilt_2
unikn::seecol(vanderbilt_2, main = "Vanderbilt University 2 (neutral)") # view color palette

}
\seealso{
\code{\link{vanderbilt_1}} for core colors of Vanderbilt University;
\code{\link{vanderbilt_3}} for saturated colors of Vanderbilt University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}}
}
\author{
\strong{unicol}, 2023-07-12
}
\concept{university color palettes.}
\keyword{datasets}
