% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associate_coordinates.R
\name{associate_coordinates}
\alias{associate_coordinates}
\title{Associate vector coordinates with a raster surface for Unity import}
\usage{
associate_coordinates(object, raster, side_length = 4097)
}
\arguments{
\item{object}{The \code{sf} object to take coordinates from. The object will be
reprojected (via \link[sf:st_transform]{sf::st_transform}) to align with \code{raster}.}

\item{raster}{A raster or file path to a raster to associate coordinates
with. Note that different rasters will produce different coordinate outputs;
you should run this function with the same raster you plan on bringing into
Unity. Any file or object that can be read via \link[terra:rast]{terra::rast} can be used.}

\item{side_length}{The side length of terrain tiles, in map units,
you intend to bring into Unity. Must be a value equal to 2^x + 1, for x
between 5 and 12. All functions in the unifir family default to 4097.}
}
\value{
A data.frame with two columns, X and Y, representing the re-aligned
coordinates. If \code{object} is point data (or anything object that
\link[sf:st_coordinates]{sf::st_coordinates} returns a single row for each row of), these rows will
be in the same order as \code{object} (and so can be appended via \link{cbind}).
}
\description{
Unity uses a left-handed coordinate system, which is effectively "flipped"
from our normal way of thinking about spatial coordinate systems. It also
can only import terrain as square tiles of side 2^x + 1, for x between 5 and
12. As a result, importing objects into a Unity scene so that they align
with terrain surfaces is trickier than you'd expect.
This function "associates" the XY coordinates from some \code{sf} object, likely a
point data set, with some raster object.
}
\examples{
\dontrun{
if (!isTRUE(as.logical(Sys.getenv("CI")))) {
  simulated_data <- data.frame(
    id = seq(1, 100, 1),
    lat = runif(100, 44.04905, 44.17609),
    lng = runif(100, -74.01188, -73.83493)
  )
  simulated_data <- sf::st_as_sf(
    simulated_data,
    coords = c("lng", "lat"),
    crs = 4326
   )
  output_files <- terrainr::get_tiles(simulated_data)
  temptiff <- tempfile(fileext = ".tif")
  terrainr::merge_rasters(output_files["elevation"][[1]], temptiff)
  associate_coordinates(simulated_data, temptiff)
}
}

}
