% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetrahedron.R
\name{runif_in_tetrahedron}
\alias{runif_in_tetrahedron}
\title{Uniform sampling in a tetrahedron}
\usage{
runif_in_tetrahedron(n, v1, v2, v3, v4)
}
\arguments{
\item{n}{number of simulations}

\item{v1, v2, v3, v4}{vertices of the tetrahedron}
}
\value{
The simulations in a \code{n} times \code{3} matrix.
}
\description{
Uniform sampling in a tetrahedron (in dimension 3).
}
\examples{
\donttest{library(rgl)
tetrahedron <- tetrahedron3d()
shade3d(tetrahedron, color="red", alpha=0.3)
vs <- tetrahedron$vb[1:3,]
sims <- runif_in_tetrahedron(100, vs[,1], vs[,2], vs[,3], vs[,4])
points3d(sims)}
}
\seealso{
\code{\link{runif_in_simplex}} for sampling in a simplex in
arbitrary dimension.
}
