% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd_save_inline}
\alias{ugd_save_inline}
\title{Inline plot rendering to a file.}
\usage{
ugd_save_inline(
  code,
  file,
  page = 0,
  width = getOption("unigd.width", 720),
  height = getOption("unigd.height", 576),
  zoom = 1,
  as = "auto",
  ...
)
}
\arguments{
\item{code}{Plotting code. See examples for more information.}

\item{file}{Filepath to save plot.}

\item{page}{Plot page to render. If this is set to \code{0}, the last page will
be selected. Can be set to a numeric plot index or plot ID
(see \code{\link[=ugd_id]{ugd_id()}}).}

\item{width}{Width of the plot.}

\item{height}{Height of the plot.}

\item{zoom}{Zoom level. (For example: \code{2} corresponds to 200\%, \code{0.5} would
be 50\%.)}

\item{as}{Renderer.}

\item{...}{Additional parameters passed to \code{ugd(...)}}
}
\value{
No return value. Plot will be saved to file.
}
\description{
Convenience function for quick inline plot rendering.
This is similar to \code{\link[=ugd_save]{ugd_save()}} but the plotting code
is specified inline and an unigd graphics device is managed
(created and closed) automatically. Starting a device with \code{\link[=ugd]{ugd()}} is
therefore not necessary.
}
\examples{
tf <- tempfile(fileext=".svg")
on.exit(unlink(tf))

ugd_save_inline({
  plot.new()
  lines(c(0.5, 1, 0.5), c(0.5, 1, 1))
}, file = tf)
}
