% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun_2.R
\name{shades_of}
\alias{shades_of}
\title{Get n shades of a color.}
\usage{
shades_of(n = 5, col_1 = "black", col_n = "white", alpha = NA)
}
\arguments{
\item{n}{Number of desired colors.
Default: \code{n = 5}.}

\item{col_1}{Initial color.
Default: \code{col_1 = "black"}.}

\item{col_n}{Final (n-th) color.
Default: \code{col_n = "white"}.}

\item{alpha}{A factor modifying the opacity alpha 
(as \code{alpha.f} in \code{\link{adjustcolor}}) to a value in \code{[0, 1]}. 
Default: \code{alpha = NA} (i.e., no modification of opacity).}
}
\description{
\code{shades_of} returns a vector of \code{n} colors that are 
shades of a color gradient ranging 
from an initial color \code{col_1} to a final color \code{col_n}.
}
\details{
By default, the color gradient returned contains \code{n = 5} colors 
that range from the initial color \code{col_1 = "black"} 
to the final color \code{col_n = "white"}.  
Specifying different values for \code{n} and the 
initial or final colors yields different color ranges. 

\code{shades_of} is mostly a wrapper for a special \code{\link{usecol}} command. 
However, \code{\link{usecol}} allows defining more 
complex color gradients (e.g., by specifying more than two colors).
}
\examples{
grey50 <- shades_of(50, col_1 = 'grey1')
seecol(grey50, main = "50 shades of grey1")

blue_black <- shades_of(5, Seeblau, col_n = "black")
seecol(blue_black, main = "5 shades from Seeblau to black")

wine_white <- shades_of(6, Bordeaux, alpha = 1/2)
seecol(wine_white, col_brd = "black", lwd_brd = .5, 
       main = "Shades of semi-transparent Bordeaux")
  
}
\seealso{
\code{\link{seepal}} for plotting color palettes;  
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors;  
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors; 
\code{\link{ac}} for adjusting color transparency.

Other color functions: 
\code{\link{ac}()},
\code{\link{demopal}()},
\code{\link{grepal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{simcol}()},
\code{\link{usecol}()}
}
\concept{color functions}
