% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{eth_pal}
\alias{eth_pal}
\title{Default colors of the ETH Zurich.}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://ethz.ch/staffnet/en/service/communication/corporate-design/digital-media/web-colours.html}.
}
\usage{
eth_pal
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{eth_pal} provides the default color palette 
of the \href{https://ethz.ch/}{ETH Zürich}, Switzerland.
}
\details{
The Swiss abbreviation "ETH" stands for "Eidgenössische Technische Hochschule".
}
\examples{
eth_pal
seecol(eth_pal)  # view color palette
demopal(eth_pal, type = 3, main = "Default colors of the ETH Zürich")

}
\seealso{
\code{\link{eth_pal_light}} and \code{\link{eth_pal_grey}} for alternative colors of the ETH Zurich;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_grey}},
\code{\link{eth_pal_light}},
\code{\link{mpg_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_konstanz}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}}
}
\author{
Hansjoerg Neth, 2022-10-25.
}
\concept{contributed color palettes}
\keyword{datasets}
