% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_ulm_2}
\alias{uni_ulm_2}
\title{Departmental colors of the University of Ulm}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on 
\url{https://www.uni-ulm.de/misc/corporate-design/#c875952}.
}
\usage{
uni_ulm_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_ulm_2} provides the four departmental colors 
of the \href{https://www.uni-ulm.de/}{University of Ulm}, Germany.
}
\details{
The named colors of \code{uni_ulm_2} correspond to the following departments:

\enumerate{
\item \code{blau}: Medizin
\item \code{rot}: Ingenieurwissenschaften, Informatik und Psychologie
\item \code{gruen}: Mathematik und Wirtschaftswissenschaften
\item \code{orange}: Naturwissenschaften 
}

See the \code{\link{ac}} and \code{\link{usecol}} functions for creating color gradients.
}
\examples{
uni_ulm_2
seecol(uni_ulm_2, main = "Department colors of the University of Ulm")
demopal(uni_ulm_2, type = 2, seed = 123,
        main = "Departmental colors of Ulm University")
        
# 5-color gradient:
uni_ulm_5 <- usecol(c(uni_ulm_2["rot"], "white"), n = 6)[1:5]

}
\seealso{
\code{\link{uni_ulm_1}} for the main colors of the University of Ulm;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}}
}
\author{
\strong{unikn}, 2022-12-30.
}
\concept{contributed color palettes}
\keyword{datasets}
