% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_functions.R
\name{uniset_updateSettings}
\alias{uniset_updateSettings}
\title{Update Settings of Target Package}
\usage{
uniset_updateSettings(uniset_handover, setupFunc = NULL, silent = FALSE)
}
\arguments{
\item{uniset_handover}{List length two, containing two elements:
\enumerate{
\item \code{pkgname}: The name of the target package.
\item \code{funcname}: The name of the function in the target package handing over
the required values. See examples at \code{\link{uniset}}.
}}

\item{setupFunc}{Character length one. The name of the function in the target
package performing the setup, i.e. the name of the function that is
containing the \code{uniset} function \code{\link{uniset_setup}}. Defaults to
'NULL'; has to be changed.}

\item{silent}{Logical. If a confirmation should be printed. Defaults
to 'FALSE'}
}
\value{
This function is called for its side effects, i.e to
manually update / (re-)source the settings file. Returns (invisible)
'FALSE' if the update was unsuccessful, otherwise an (invisible) list with
the settings sourced from the settings.R file.
}
\description{
Manually read in the settings-file in the target package settings
home directory as specified in the .Renviron file.
}
\section{Important}{
 This function is meant to be called from within the
target package.
}

\section{Note}{
 Please refer to \code{\link{uniset}} for a link to examples
and a real-world demo.
}

\examples{
{
\dontrun{
# to be called from within the target package
uniset_updateSettings(uniset_handover, "dogPack_demo_setup")
}
}
}
