% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vuong.R
\name{pairwise.vuong.test}
\alias{pairwise.vuong.test}
\title{Pairwise vuong test}
\usage{
pairwise.vuong.test(
  ...,
  lt,
  p.adjust.method = p.adjust.methods,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{...}{\code{\link[unitquantreg]{unitquantreg}} objects separated by commas.}

\item{lt}{a list with one or more \code{\link[unitquantreg]{unitquantreg}} objects.}

\item{p.adjust.method}{a character string specifying the method for multiple
testing adjustment; almost always one of
\code{p.adjust.methods}. Can be abbreviated.}

\item{alternative}{indicates the alternative hypothesis and must be one
of \code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.
Can be abbreviated.}
}
\value{
Object of class \code{"pairwise.htest"}
}
\description{
Calculate pairwise comparisons between fitted models performing
vuong test for objects of class \code{\link[unitquantreg]{unitquantreg}}.
}
\examples{
data(water, package = "unitquantreg")

models  <- c("johnsonsb", "kum", "leeg", "ubs", "uburrxii", "uchen", "ughne", "ughnx",
"ugompertz", "ulogistic", "uweibull")
fits <- lapply(models, function(M) unitquantreg(formula = phpws ~ mhdi,
tau = 0.5, data = water, family = M))

ans <- pairwise.vuong.test(lt = fits)
ans


}
\seealso{
\code{\link{vuong.test}}, \code{\link{p.adjust}}
}
