% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mupdog.R
\name{plot.mupdog}
\alias{plot.mupdog}
\title{Draw a genotype plot from the output of \code{\link{mupdog}}.}
\usage{
\method{plot}{mupdog}(x, index, use_colorblind = TRUE, ...)
}
\arguments{
\item{x}{A mupdog object.}

\item{index}{The column number of the gene to plot.}

\item{use_colorblind}{Should we use a colorblind-safe palette
(\code{TRUE}) or not (\code{FALSE})? \code{TRUE} is only allowed
if the ploidy is less than or equal to 6.}

\item{...}{Not used.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object for the genotype plot.
}
\description{
A wrapper for \code{\link{plot_geno}}. This will create a genotype plot for a single SNP.
}
\details{
On a genotype plot, the x-axis contains the counts of the non-reference allele and the y-axis
contains the counts of the reference allele. The dashed lines are the expected counts (both reference and alternative)
given the sequencing error rate and the allele-bias. The plots are color-coded by the maximum-a-posterior genotypes.
Transparency is proportional to the maximum posterior probability for an
individual's genotype. Thus, we are less certain of the genotype of more transparent individuals.
}
\examples{
data("mupout")
plot(mupout, 4)

}
\seealso{
\describe{
  \item{\code{\link{plot_geno}}}{The underlying plotting function.}
  \item{\code{\link{mupdog}}}{Creates a \code{mupdog} object.}
}
}
\author{
David Gerard
}
