% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oracle.R
\name{oracle_mis_vec_from_joint}
\alias{oracle_mis_vec_from_joint}
\title{Get the oracle misclassification error rates (conditional on
true genotype) directly from the
joint distribution of the genotype and the oracle estimator.}
\usage{
oracle_mis_vec_from_joint(jd)
}
\arguments{
\item{jd}{A matrix of numerics. Element (i, j) is the probability
of genotype i - 1 and estimated genotype j - 1. This is usually
obtained from \code{\link{oracle_joint}}.}
}
\value{
A vector of numerics. Element i is the oracle misclassification
    error rate when genotyping an individual with actual
    genotype i + 1.
}
\description{
Get the oracle misclassification error rates (conditional on
true genotype) directly from the
joint distribution of the genotype and the oracle estimator.
}
\examples{
## Hardy-Weinberg population with allele-frequency of 0.75.
## Moderate bias and moderate overdispersion.
ploidy <- 6
dist <- stats::dbinom(0:ploidy, ploidy, 0.75)
jd <- oracle_joint(n = 100, ploidy = ploidy, seq = 0.001,
                   bias = 0.7, od = 0.01, dist = dist)
oracle_mis_vec_from_joint(jd = jd)

## Compare to oracle_cor
oracle_mis_vec(n = 100, ploidy = ploidy, seq = 0.001,
               bias = 0.7, od = 0.01, dist = dist)

}
\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
}
}
\seealso{
\code{\link{oracle_joint}} for getting \code{jd}.
    \code{\link{oracle_mis_vec}} for not having to first calculate
    \code{jd}.
}
\author{
David Gerard
}
