% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashdog.R
\name{plot.flexdog}
\alias{plot.flexdog}
\title{Draw a genotype plot from the output of \code{\link{flexdog}}.}
\usage{
\method{plot}{flexdog}(x, use_colorblind = TRUE, ...)
}
\arguments{
\item{x}{A \code{flexdog} object.}

\item{use_colorblind}{Should we use a colorblind-safe palette
(\code{TRUE}) or not (\code{FALSE})? \code{TRUE} is only allowed
if the ploidy is less than or equal to 6.}

\item{...}{Not used.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object for the genotype plot.
}
\description{
A wrapper for \code{\link{plot_geno}}. This will create a genotype plot for a single SNP.
}
\details{
On a genotype plot, the x-axis contains the counts of the non-reference allele and the y-axis
contains the counts of the reference allele. The dashed lines are the expected counts (both reference and alternative)
given the sequencing error rate and the allele-bias. The plots are color-coded by the maximum-a-posterior genotypes.
Transparency is proportional to the maximum posterior probability for an
individual's genotype. Thus, we are less certain of the genotype of more transparent individuals. These
types of plots are used in Gerard et. al. (2018) and Gerard and Ferrão (2019).
}
\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
  \item{Gerard, D. and Ferrão, L. F. V. (2019). Priors for Genotyping Polyploids. \emph{bioRxiv}. doi: \href{https://doi.org/10.1101/751784}{10.1101/751784}.}
}
}
\seealso{
\describe{
  \item{\code{\link{plot_geno}}}{The underlying plotting function.}
  \item{\code{\link{flexdog}}}{Creates a \code{flexdog} object.}
}
}
\author{
David Gerard
}
