% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uni_em_const}
\alias{uni_em_const}
\title{EM algorithm to fit weighted ash objective with a uniform
mixing component.}
\usage{
uni_em_const(weight_vec, lmat, pi_init, alpha, lambda, itermax, obj_tol)
}
\arguments{
\item{weight_vec}{A vector of weights. Each element of \code{weight_vec} corresponds
to a column of \code{lmat}.}

\item{lmat}{A matrix of inner weights. The columns are the "individuals" and the rows are the "classes."}

\item{pi_init}{The initial values of \code{pivec}. Each element of \code{pi_init}
corresponds to a row of \code{lmat}.}

\item{alpha}{The mixing weight for the uniform component.
This should be small (say, less tahn 10^-3).}

\item{lambda}{A vector of penalties on the pi's (corresponding to the rows
of \code{lmat}).
This can either be of length 1, in which case the same penalty is applied
to each of the pi's. Or it can be the same length of \code{pivec}, in
which case a different penalty is applied to each of the pi's. Larger
penalties generally increase the value of the pi's, not shrink them.}

\item{itermax}{The maximum number of EM iterations to take.}

\item{obj_tol}{The objective stopping criterion.}
}
\value{
A vector of numerics. The update of \code{pivec} in
    \code{\link{flexdog_full}}.
}
\description{
Solves the following optimization problem
\deqn{\max_{\pi} \sum_k w_k \log(\alpha / (K+1) + (1 - \alpha)\sum_j \pi_j \ell_jk).}
It does this using a weighted EM algorithm.
}
\author{
David Gerard
}
