% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflexdog.R
\name{rgeno}
\alias{rgeno}
\title{Simulate individual genotypes from one of the supported \code{\link{flexdog}} models.}
\usage{
rgeno(
  n,
  ploidy,
  model = c("hw", "bb", "norm", "f1", "s1", "flex", "uniform"),
  allele_freq = NULL,
  od = NULL,
  p1geno = NULL,
  p2geno = NULL,
  pivec = NULL,
  mu = NULL,
  sigma = NULL
)
}
\arguments{
\item{n}{The number of observations.}

\item{ploidy}{The ploidy of the species.}

\item{model}{What form should the prior take? See Details in \code{\link{flexdog}}.}

\item{allele_freq}{If \code{model = "hw"}, then this is the allele frequency of the population.
For any other model, this should be \code{NULL}.}

\item{od}{If \code{model = "bb"}, then this is the overdispersion parameter of the beta-binomial
distribution. See \code{\link{betabinom}} for details. For any other model, this should be
\code{NULL}.}

\item{p1geno}{Either the first parent's genotype if \code{model = "f1"},
or the only parent's
genotype if \code{model = "s1"}.
For any other model, this should be \code{NULL}.}

\item{p2geno}{The second parent's genotype if \code{model = "f1"}.
For any other model, this should be \code{NULL}.}

\item{pivec}{A vector of probabilities. If \code{model = "ash"}, then this represents
the mixing proportions of the discrete uniforms. If
\code{model = "flex"}, then element \code{i} is the probability of genotype \code{i - 1}.
For any other model, this should be \code{NULL}.}

\item{mu}{If \code{model = "norm"}, this is the mean of the normal.
For any other model, this should be \code{NULL}.}

\item{sigma}{If \code{model = "norm"}, this is the standard deviation of the normal.
For any other model, this should be \code{NULL}.}
}
\value{
A vector of length \code{n} with the genotypes of the sampled individuals.
}
\description{
This will simulate genotypes of a sample of individuals drawn from one of the populations supported by
\code{\link{flexdog}}. See the details of \code{\link{flexdog}} for the models allowed. These genotype
distributions are described in detail in Gerard and Ferrão (2020).
}
\details{
List of non-\code{NULL} arguments:
\describe{
  \item{\code{model = "flex"}:}{\code{pivec}}
  \item{\code{model = "hw"}:}{\code{allele_freq}}
  \item{\code{model = "f1"}:}{\code{p1geno} and \code{p2geno}}
  \item{\code{model = "s1"}:}{\code{p1geno}}
  \item{\code{model = "uniform"}:}{no non-\code{NULL} arguments}
  \item{\code{model = "bb"}:}{\code{allele_freq} and \code{od}}
  \item{\code{model == "norm"}:}{\code{mu} and \code{sigma}}
}
}
\examples{
## F1 Population where parent 1 has 1 copy of the referenc allele
## and parent 2 has 4 copies of the reference allele.
ploidy <- 6
rgeno(n = 10, ploidy = ploidy, model = "f1", p1geno = 1, p2geno = 4)

## A population in Hardy-Weinberge equilibrium with an
## allele frequency of 0.75
rgeno(n = 10, ploidy = ploidy, model = "hw", allele_freq = 0.75)

}
\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
  \item{Gerard, David, and Luís Felipe Ventorim Ferrão. "Priors for genotyping polyploids." Bioinformatics 36, no. 6 (2020): 1795-1800. \href{https://doi.org/10.1093/bioinformatics/btz852}{DOI:10.1093/bioinformatics/btz852}.}
}
}
\author{
David Gerard
}
