% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_userMetrics.R
\name{bitly_UserMetricsReferrers}
\alias{bitly_UserMetricsReferrers}
\title{Returns aggregate metrics about the pages referring click traffic to all of the 
authenticated user's Bitlinks.}
\usage{
bitly_UserMetricsReferrers(limit = 1000, unit = c("minute", "hour", "day",
  "week", "month"), rollup = c("false", "true"), units = -1,
  showRequestURL = FALSE)
}
\arguments{
\item{limit}{- 1 to 1000 (default=1000).}

\item{unit}{- minute, hour, day, week or month, default: day; Note: when unit is minute the 
maximum value for units is 60.}

\item{rollup}{- true or false. Return data for multiple units rolled up to a single result 
instead of a separate value for each period of time.}

\item{units}{- an integer representing the time units to query data for. Pass -1 to return all 
units of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
clicks - the number of clicks referred from this URL.

referrer - the URL referring clicks.
}
\description{
See \url{http://dev.bitly.com/user_metrics.html#v3_user_referrers}
}
\note{
When a unit is specified (always the case), rollup is always (!) true.
}
\examples{
\dontrun{
bitly_token <- bitly_auth(key = "", secret = "")
user_Metrics_Referrers(unit = "day", units = -1, limit = 100, rollup = "true")
}

}

