% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_LinksInfo}
\alias{bitly_LinksInfo}
\title{Used to return the page title for a given Bitlink.}
\usage{
bitly_LinksInfo(hashIN = NULL, shortUrl = NULL, expand_user = "true",
  showRequestURL = FALSE)
}
\arguments{
\item{hashIN}{- refers to one bitly hashes, (e.g.:  2bYgqR or a-custom-name). Required}

\item{shortUrl}{- refers to one Bitlinks e.g.: http://bit.ly/1RmnUT or http://j.mp/1RmnUT. 
Optional.}

\item{expand_user}{- optional true|false (default) - include extra user info in response.}

\item{showRequestURL}{- show URL which has been build and requested from server. 
For debug purposes.}
}
\value{
short_url - this is an echo back of the shortUrl request parameter.

hash - this is an echo back of the hash request parameter.

user_hash - the corresponding bitly user identifier.

global_hash - the corresponding bitly aggregate identifier.

error - indicates there was an error retrieving data for a given shortUrl or hash. An 
example error is "NOT_FOUND".

title - the HTML page title for the destination page (when available).

created_by - the bitly username that originally shortened this link, if the 
link is public. Otherwise, null.

created_at - the epoch timestamp when this Bitlink was created.
}
\description{
See \url{http://dev.bitly.com/links.html#v3_info}
}
\note{
Either shortUrl or hash must be given as a parameter (or both).

The maximum number of shortUrl and hash parameters is 15.
}
\examples{
\dontrun{ 
bitly_token <- bitly_auth(key = "be03aead58f23bc1aee6e1d7b7a1d99d62f0ede8", 
secret = "b7e4abaf8b26ec4daa92b1e64502736f5cd78899")
bitly_LinksInfo(shortUrl = "http://bit.ly/DPetrov")
bitly_LinksInfo(hash = "DPetrov", showRequestURL = TRUE) 
bitly_LinksInfo(hash = "DPetrov", expand_user = "true")

## hash is the one which is only returned. Dont use
bitly_LinksInfo(shortUrl = "on.natgeo.com/1bEVhwE", hash = "DPetrov") 

## manyHashes <- list("DPetrov", "1QU8CFm", "1R1LPSE", "1LNqqva")
## for (u in 1:length(manyHashes)) {
##   print(bitly_LinksInfo(hashIN = manyHashes[[u]], showRequestURL = TRUE))
## }
}

}

