'.compose_basemap' <- function(style="internal.CartoDB") {
   if (.skipPlot(TRUE))
      return(NULL)
   sc <- getOption("ursaPngScale")
   if (is.null(sc)||(!is.numeric(sc)))
      return(NULL)
   print(sc)
   invisible(NULL)
}
'.panel_basemap' <- function(style="internal.CartoDB",...) {
   if (.skipPlot(TRUE))
      return(NULL)
   sc <- getOption("ursaPngScale")
   if (is.null(sc)||(!is.numeric(sc)))
      return(NULL)
   g0 <- session_grid()
   str(g0)
   c1 <- session_cellsize()
   c2 <- 2*6378137*pi/(2^(1:21+8))
   d <- abs(c2-c1)
   print(d)
   ind <- which.min(d)
   print(ind)
   print(d[ind])
   print(.is.near(d[ind],0))
   if (!is.na(.is.near(d[ind],0,verbose=TRUE))) {
      b <- .geomap(style=style)
      ret <- panel_raster(b,...)
      return(invisible(ret))
   }
   g1 <- regrid(g0,res=c2[ind])
   print(g1,digits=14)
   session_grid(g1)
  # .is.near(ursa(obj,"cellsize"),2*6378137*pi/(2^(1:21+8))))   
  # g1 <- regrid(g0,mul=sc)
   b <- .geomap(style=style)
   str(b)
   options(warn=1)
   b <- .gdalwarp(b,grid=g0,resample=c("bilinear","lanczos")[1],verbose=TRUE)
   session_grid(g0)
   ret <- panel_raster(b,...)
   invisible(ret)
}
