% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/impute.r
\name{simple.impute.tbl_df}
\alias{simple.impute.tbl_df}
\title{simple.impute.tbl_df}
\usage{
\method{simple.impute}{tbl_df}(x, fun = median, ...)
}
\arguments{
\item{x}{A data.frame}

\item{fun}{The function with which to fill in missing values}

\item{\dots}{Further arguments}
}
\value{
A data.frame with the missing values imputed.
}
\description{
Function for imputing a tbl_df with missing data.
}
\details{
Provides the ability to simply impute data based on a simple measure such as mean or median.  For more robust imputation see the packages Amelia, mice or mi.

Each column is imputed independently.
}
\examples{
theDF <- data.frame(A=1:10, B=1:10, C=1:10)
theDF[c(1, 4, 6), c(1)] <- NA
theDF[c(3, 4, 8), c(3)] <- NA

simple.impute.data.frame(theDF)
simple.impute.data.frame(theDF, mean)
simple.impute.data.frame(theDF, constant(4))
}
\author{
Jared P. Lander
}

