\name{processOpenSesameIAT}
\alias{processOpenSesameIAT}
\title{
processOpenSesameIAT
}
\description{
This function reads IAT files as generated by the OpenSesame script available at [INSERT URL].
}
\usage{
processOpenSesameIAT(dataPath,
                     blocks.sizes = c(18, 36, 48, 36, 48),
                     blocks.congruent = c(2, 3),
                     blocks.incongruent = c(4, 5),
                     blocks.realTrials = c(3, 5),
                     blocks.practiceTrials = c(2, 4),
                     responseTime.min = 400,
                     responseTime.max = 2500,
                     responseTime.penalty = 600,
                     outputFile = NULL,
                     wideOutputFile = NULL,
                     showLog = TRUE,
                     filenameRegEx = "subject-(\\\\d+)(\\\\w+)\\\\.csv",
                     regExValues = c("subject","session"),
                     participantVarName = "subject",
                     taskVarName = "session",
                     openSesameVarNames = list(correct = "correct",
                                               response_time = "response_time"),
                     roundOutput = 6,
                     decimalSeparator = ".")
}
\arguments{
  \item{dataPath}{
  A directory containing the .csv files that OpenSesame provides.
}
  \item{blocks.sizes}{
  A vector containing the number of trials of each block.
}
  \item{blocks.congruent}{
  A vector containing the numbers of the congruent blocks.
}
  \item{blocks.incongruent}{
  A vector containing the numbers of the incongruent blocks.
}
  \item{blocks.realTrials}{
  A vector containing the numbers of the real trials.
}
  \item{blocks.practiceTrials}{
  A vector containing the numbers of the practice trials.
}
\item{responseTime.min}{
  Minimum number of milliseconds of response time (all shorter times will
  be removed).
}
\item{responseTime.max}{
  Maximum number of milliseconds of response time (all longer times will
  be replaced with this number).
}
\item{responseTime.penalty}{
  Penalty in milliseconds to add to the response times for incorrect
  responses.
}
\item{outputFile}{
  If specified, the aggregated datafile is stored in this file.
}
\item{wideOutputFile}{
  If specified, the wide version of the datafile will be stored in this file.
}
\item{showLog}{
  Boolean; if TRUE, shows the log (is stored in the resulting object anyway).
}
\item{filenameRegEx}{
  Regular expression describing the filenames. This has two purposes.
  First, only files matching this regular expression will be processed
  (note that you can set it to \code{NULL} to process all files). Second,
  by using \code{"\\1"}, \code{"\\2"}, etc, matched patterns can be
  extracted from the filenames and stored as variables in the final
  datafile (see \code{\link{sub}} for more information on regular expression
  matching). The default pattern, \code{"subject-(\\d+)(\\w+)\\.csv"},
  which is read by R as \code{"subject-(\d+)(\w+)\.csv"} (because the
  backslash is the escape symbol, double backspaces are needed to specify
  one backspace, see \code{\link{Quotes}}), assumes that all filenames start
  with \code{'subject-'}, followed by the subject number (\code{"\\d+"}
  matches one or more digits), immediately followed by one or more letters
  and digits (\code{"\\w+"} matches one or more letters or digits)
  indicating the session that the datafile pertains to. If you only have
  subject numbers, you'd use \code{"subject-(\\d+)\\.csv"} or perhaps
  \code{"subject-(\\w+)\\.csv"} if the subjects could also have letters
  in their identifiers. Note that you have to include the variable names
  of each of these extractable patterns in \code{regExValues}!
}
\item{regExValues}{
  Here, the names of the variables extracted using the regular expression
  specified in \code{filenameRegEx} are provided. Must of course have the
  same length as the number of patterns specified in \code{filenameRegEx},
  and in the same order.
}
\item{participantVarName, taskVarName}{
  Variable name of the variable identifying participants and tasks (usually
  extracted from the filename, so should be a value in regExValues). Tasks
  are usually different within-subject conditions.
}
\item{openSesameVarNames}{
  A list with the two elements 'correct' and 'response_time', which should
  be the variable names that OpenSesame used to write, for each trial, whether
  the response was correct or not ('correct') and what the response time
  was ('response_time');
}
\item{roundOutput}{
  Number of digits to round the output to. This is useful for importing into
  a program that doesn't quite get how storing numbers works, such as SPSS or
  Excel; they sometimes don't manage to import numbers with many decimals.
}
\item{decimalSeparator}{
  When working with e.g. Excel, it can be easier to just specify the decimal
  separator rather than switch Excel's (and therefore Windows') locale.
}
}
\details{

Note that this function was developed to read the OpenSesame IAT datafiles
created by the OpenSesame script developed by Kenny Wolfs, Jacques van
Lankveld, and Frederik van Acker at the Open University of the Netherlands.
If you use a different version (for example, the one contributed to the
OpenSesame paradigm repository by Hansika Kapoor, see
\url{http://osdoc.cogsci.nl/standard-tasks/#implicit-association-test-iat}),
you will have to specify the variable names you specified to OpenSesame
for the response time and for whether the response was correct in
\code{openSesameVarNames}. For example, if you use Hansika's IAT task,
you'll have to specify \code{openSesameVarNames = list(correct = "correct",
response_time = "avg_rt")}

Similarly, of course you will probably have to specify the number of
trials per block etc. Also, you may want to set showLog to FALSE, as the
logging is quite detailed.
}
\value{
An object with the raw files, the processed files, and the file converted
to wide format. But most users will probably specify \code{outputFile}
and/or \code{wideOutputFile} to just export the output files directly.
}
\references{
Mathot, S., Schreij, D., & Theeuwes, J. (2012). OpenSesame: An open-source, graphical experiment builder for the social sciences. \emph{Behavior Research Methods}, 44(2), 314-324. doi:10.3758/s13428-011-0168-7

Kapoor, H. (2015). The creative side of the Dark Triad. \emph{Creativity Research Journal}, 27(1), 58-67. doi:10.1080/10400419.2014.961775.
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters <gjalt-jorn@userfriendlyscience.com>
}

\examples{

\dontrun{
### This will process all files in the specified directory, but not
### export anything
processed <- processOpenSesameIAT("C:/directory/with/datafiles");

### This will export both the aggregated datafile and the wide datafile
processed <- processOpenSesameIAT("C:/directory/with/datafiles",
                                  outputFile="C:/directory/aggregated.csv",
                                  wideOutputFile="C:/directory/wide.csv");

}

}
\keyword{ utilities }