% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{use_package}
\alias{use_package}
\alias{use_dev_package}
\title{Depend on another package}
\usage{
use_package(package, type = "Imports", min_version = NULL)

use_dev_package(package, type = "Imports")
}
\arguments{
\item{package}{Name of package to depend on.}

\item{type}{Type of dependency: must be one of "Imports", "Depends",
"Suggests", "Enhances", or "LinkingTo" (or unique abbreviation). Matching
is case insensitive.}

\item{min_version}{Optionally, supply a minimum version for the package.
Set to \code{TRUE} to use the currently installed version.}
}
\description{
\code{use_package()} adds a CRAN package dependency to \code{DESCRIPTION} and offers a
little advice about how to best use it. \code{use_dev_package()} adds a versioned
dependency on an in-development GitHub package, adding the repo to \code{Remotes}
so it will be automatically installed from the correct location.
}
\examples{
\dontrun{
use_package("ggplot2")
use_package("dplyr", "suggests")
use_dev_package("glue")
}
}
\seealso{
The \href{http://r-pkgs.had.co.nz/description.html#dependencies}{dependencies section} of \href{http://r-pkgs.had.co.nz}{R Packages}.
}
