% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version.R
\name{use_version}
\alias{use_version}
\alias{use_dev_version}
\title{Increment package version}
\usage{
use_version(which = NULL, push = FALSE)

use_dev_version(push = FALSE)
}
\arguments{
\item{which}{A string specifying which level to increment, one of: "major",
"minor", "patch", "dev". If \code{NULL}, user can choose interactively.}

\item{push}{If \code{TRUE}, also attempts to push the commits to the remote
branch.}
}
\description{
usethis supports semantic versioning, which is described in more detail in
the \href{https://r-pkgs.org/lifecycle.html#sec-lifecycle-version-number}{version section} of \href{https://r-pkgs.org}{R Packages}. A version number breaks down like so:

\if{html}{\out{<div class="sourceCode">}}\preformatted{<major>.<minor>.<patch>       (released version)
<major>.<minor>.<patch>.<dev> (dev version)
}\if{html}{\out{</div>}}

\code{use_version()} increments the "Version" field in \code{DESCRIPTION}, adds a new
heading to \code{NEWS.md} (if it exists), commits those changes (if package uses
Git), and optionally pushes (if safe to do so). It makes the same update to a
line like \code{PKG_version = "x.y.z";} in \code{src/version.c} (if it exists).

\code{use_dev_version()} increments to a development version, e.g. from 1.0.0 to
1.0.0.9000. If the existing version is already a development version with
four components, it does nothing. Thin wrapper around \code{use_version()}.
}
\examples{
\dontrun{
## for interactive selection, do this:
use_version()

## request a specific type of increment
use_version("minor")
use_dev_version()
}

}
\seealso{
The \href{https://r-pkgs.org/lifecycle.html#sec-lifecycle-version-number}{version section} of \href{https://r-pkgs.org}{R Packages}.
}
