% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns.R
\name{fit_model}
\alias{fit_model}
\title{Fit model and obtain parameter estimates}
\usage{
fit_model(data, id_vector, param_names, initial_params, free_param_index,
  n_min_biphasic, model_list, whichcurve = get_biphasic,
  forward_param_transform_fn, inv_param_transform_fn, searchmethod)
}
\arguments{
\item{data}{dataframe with columns for each subject's identifier ('id'), viral load measurements ('vl'), and timing of sampling ('time')}

\item{id_vector}{vector of identifiers corresponding to the subjects to be fitted.}

\item{param_names}{names of parameter vector.}

\item{initial_params}{named vector of the initial parameter guess.}

\item{free_param_index}{logical vector indicating whether the parameters A, delta, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE) for the biphasic model and c(FALSE, FALSE, TRUE, TRUE) for the single phase model.}

\item{n_min_biphasic}{the minimum number of data points required to fit the biphasic model. Defaults to 6. It is highly advised not to go below this threshold.}

\item{model_list}{character indicating which model is to be fit. Can be either 'four' for the biphasic model, or 'two' for the single phase model. Defaults to 'four'.}

\item{whichcurve}{indicates which model prediction function to use. Should be get_biphasic for the biphasic model or get_singlephase for the singlephase model. Defaults to get_biphasic.}

\item{forward_param_transform_fn}{list of transformation functions to be used when fitting the model in optim. Defaults to log transformations for all parameters (to allow unconstrained optimization).}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}

\item{searchmethod}{optimization algorithm to be used in optim. Defaults to Nelder-Mead.}
}
\description{
This function fits either the biphasic or single phase model to the processed data and extracts the best-fit parameters.
}
