% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-map.R
\name{plot_usmap}
\alias{plot_usmap}
\title{Conveniently plot basic US map}
\usage{
plot_usmap(regions = c("states", "state", "counties", "county"),
  include = c(), theme = theme_map(), lines = "black")
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"counties"}, \code{"county"}).
The default is \code{"states"}.}

\item{include}{The regions to include in the output data frame. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name.}

\item{theme}{The theme that should be used for plotting the map. The default
is \code{\link[ggthemes]{theme_map}}.}

\item{lines}{The line color to be used in the map. Corresponds to the
\code{colour} option in the \code{\link[ggplot2]{aes}} mapping. The default
is \code{"black"}. \href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{Click here}
for more color options.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that contains a basic
  US map with the described parameters. Since the result is a \code{ggplot}
  object, it can be extended with more \code{geom} layers, scales, labels,
  themes, etc.
}
\description{
Conveniently plot basic US map
}
\examples{
plot_usmap()
plot_usmap(regions = "states")
plot_usmap(regions = "counties")
plot_usmap(regions = "state")
plot_usmap(regions = "county")

# Output is ggplot object so it can be extended
# with any number of ggplot layers
library(ggplot2)
plot_usmap(include = c("CA", "NV", "ID", "OR", "WA")) +
  labs(title = "Western States")

}
\seealso{
\code{\link{usmap}}, \code{\link[ggplot2]{theme}}
}

