% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_mbr.R
\name{mbr}
\alias{mbr}
\title{Meta-BR or 2BR for multi-label Classification}
\usage{
mbr(mdata, base.method = getOption("utiml.base.method", "SVM"), folds = 1,
  phi = 0, ..., predict.params = list(), cores = getOption("utiml.cores",
  1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.method}{A string with the name of the base method. (Default:
\code{options("utiml.base.method", "SVM")})}

\item{folds}{The number of folds used in internal prediction. If this value
is 1 all dataset will be used in the first prediction. (Default: 1)}

\item{phi}{A value between 0 and 1 to determine the correlation coefficient,
The value 0 include all labels in the second phase and the 1 only the
predicted label. (Default: 0)}

\item{...}{Others arguments passed to the base method for all subproblems.}

\item{predict.params}{A list of default arguments passed to the predictor
method. (Default: \code{list()})}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{MBRmodel} containing the set of fitted
  models, including:
  \describe{
     \item{labels}{A vector with the label names.}
     \item{phi}{The value of \code{phi} parameter.}
     \item{correlation}{The matrix of label correlations used in combination
       with \code{phi} parameter to define the labels used in the second
       step. }
     \item{basemodel}{The BRModel used in the first iteration.}
     \item{models}{A list of models named by the label names used in the
       second iteration. }
  }
}
\description{
Create a Meta-BR (MBR) classifier to predic multi-label data. To this, two
round of Binary Relevance is executed, such that, the first step generates
new attributes to enrich the second prediction.
}
\details{
This implementation use complete training set for both training and
prediction steps of 2BR. However, the \code{phi} parameter may be used to
remove labels with low correlations on the second step.
}
\examples{
model <- mbr(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use 10 folds and different phi correlation with J48 classifier
model <- mbr(toyml, 'J48', 10, 0.2)

# Run with 4 cores
 model <- mbr(toyml, "SVM", cores = 4, seed = 123)

# Set a specific parameter
model <- mbr(toyml, 'KNN', k=5)
}
}
\references{
Tsoumakas, G., Dimou, A., Spyromitros, E., Mezaris, V., Kompatsiaris, I., &
   Vlahavas, I. (2009). Correlation-based pruning of stacked binary relevance
   models for multi-label learning. In Proceedings of the Workshop on
   Learning from Multi-Label Data (MLD'09) (pp. 22-30).
 Godbole, S., & Sarawagi, S. (2004). Discriminative Methods for Multi-labeled
   Classification. In Data Mining and Knowledge Discovery (pp. 1-26).
}
\seealso{
Other Stacking methods: \code{\link{brplus}}

Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{ctrl}},
  \code{\link{dbr}}, \code{\link{ebr}}, \code{\link{ecc}},
  \code{\link{ns}}, \code{\link{prudent}},
  \code{\link{rdbr}}
}

