% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{create_kfold_partition}
\alias{create_kfold_partition}
\title{Create the k-folds partition based on the specified algorithm}
\usage{
create_kfold_partition(mdata, k = 10, method = c("random", "iterative",
  "stratified"))
}
\arguments{
\item{mdata}{A mldr dataset.}

\item{k}{The number of desirable folds. (Default: 10)}

\item{method}{The method to split the data. The default methods are:
\describe{
  \item{random}{Split randomly the folds.}
  \item{iterative}{Split the folds considering the labels proportions
                    individually. Some specific label can not occurs in all
                    folds.}
  \item{stratified}{Split the folds considering the labelset
                        proportions.}
}
You can also create your own partition method. See the note and example
sections to more details. (Default: "random")}
}
\value{
An object of type kFoldPartition.
}
\description{
This method create the kFoldPartition object, from it is possible create
the dataset partitions to train, test and optionally to validation.
}
\note{
To create your own split method, you need to build a function that
 receive a mldr object and a list with the proportions of examples in each
 fold and return an other list with the index of the elements for each fold.
}
\examples{
k10 <- create_kfold_partition(toyml, 10)
k5 <- create_kfold_partition(toyml, 5, "stratified")

sequencial_split <- function (mdata, r) {
 S <- list()

 amount <- trunc(r * mdata$measures$num.instances)
 indexes <- c(0, cumsum(amount))
 indexes[length(r)+1] <- mdata$measures$num.instances

 S <- lapply(seq(length(r)), function (i) {
   seq(indexes[i]+1, indexes[i+1])
 })

 S
}
k3 <- create_kfold_partition(toyml, 3, "sequencial_split")
}
\references{
Sechidis, K., Tsoumakas, G., & Vlahavas, I. (2011). On the
 stratification of multi-label data. In Proceedings of the Machine
 Learning and Knowledge Discovery in Databases - European Conference,
 ECML PKDD (pp. 145-158).
}
\seealso{
\link[=partition_fold]{How to create the datasets from folds}

Other sampling: \code{\link{create_holdout_partition}},
  \code{\link{create_random_subset}},
  \code{\link{create_subset}}
}
