% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_dbr.R
\name{dbr}
\alias{dbr}
\title{Dependent Binary Relevance (DBR) for multi-label Classification}
\usage{
dbr(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  estimate.models = TRUE, ..., cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{estimate.models}{Logical value indicating whether is necessary build
Binary Relevance classifier for estimate process. The default implementation
use BR as estimators, however when other classifier is desirable then use
the value \code{FALSE} to skip this process. (Default: \code{TRUE}).}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{DBRmodel} containing the set of fitted
 models, including:
 \describe{
   \item{labels}{A vector with the label names.}
   \item{estimation}{The BR model to estimate the values for the labels.
     Only when the \code{estimate.models = TRUE}.}
   \item{models}{A list of final models named by the label names.}
 }
}
\description{
Create a DBR classifier to predict multi-label data. This is a simple approach
that enables the binary classifiers to discover existing label dependency by
themselves. The idea of DBR is exactly the same used in BR+ (the training
method is the same, excepted by the argument \code{estimate.models} that
indicate if the estimated models must be created).
}
\examples{
model <- dbr(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use Random Forest as base algorithm and 4 cores
model <- dbr(toyml, 'RF', cores = 4)
}
}
\references{
Montanes, E., Senge, R., Barranquero, J., Ramon Quevedo, J., Jose Del Coz,
   J., & Hullermeier, E. (2014). Dependent binary relevance models for
   multi-label classification. Pattern Recognition, 47(3), 1494-1508.
}
\seealso{
\code{\link[=rdbr]{Recursive Dependent Binary Relevance}}

Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{ebr}}, \code{\link{ecc}},
  \code{\link{eps}}, \code{\link{homer}},
  \code{\link{lift}}, \code{\link{lp}}, \code{\link{mbr}},
  \code{\link{ns}}, \code{\link{ppt}},
  \code{\link{prudent}}, \code{\link{ps}},
  \code{\link{rakel}}, \code{\link{rdbr}},
  \code{\link{rpc}}
}
