% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlresult.R
\name{as.mlresult}
\alias{as.mlresult}
\alias{as.mlresult.default}
\alias{as.mlresult.mlresult}
\title{Convert a matrix prediction in a multi label prediction}
\usage{
as.mlresult(predictions, probability = TRUE, ...)

\method{as.mlresult}{default}(predictions, probability = TRUE, ..., threshold = 0.5)

\method{as.mlresult}{mlresult}(predictions, probability = TRUE, ...)
}
\arguments{
\item{predictions}{a Matrix or data.frame contained the scores/probabilities
values. The columns are the labels and the rows are the examples.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{TRUE})}

\item{...}{ignored}

\item{threshold}{A single value between 0 and 1 or a list with threshold
values contained one value per label (Default: 0.5). Only used when the
predictions are not a mlresult.}
}
\value{
An object of type mlresult
}
\description{
Convert a matrix prediction in a multi label prediction
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default mlresult transform method

\item \code{mlresult}: change the mlresult type
}}

\examples{
predictions <- matrix(runif(100), ncol = 10)
colnames(predictions) <- paste('label', 1:10, sep='')

# Create a mlresult from a matrix
mlresult <- as.mlresult(predictions)
mlresult <- as.mlresult(predictions, probability = FALSE)
mlresult <- as.mlresult(predictions, probability = FALSE, threshold = 0.6)

# Change the current type of a mlresult
mlresult <- as.mlresult(mlresult, probability = TRUE)
}
