% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_esl.R
\name{esl}
\alias{esl}
\title{Ensemble of Single Label}
\usage{
esl(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  m = 10,
  w = 1,
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{m}{The number of members used in the ensemble. (Default: 10)}

\item{w}{The weight given to the choice of the less frequent labels. When it
is 0, the labels will be random choose, when it is 1 the complement of the
label frequency is used as the probability to choose each label. Values
greater than 1 will privilege the less frequent labels. (Default: 1)}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{The number of cores to parallelize the training. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{ESLmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the labels' frequencies.}
   \item{models}{A list of the multi-class models.}
  }
}
\description{
Create an Ensemble of Single Label model for multilabel classification.
}
\details{
ESL is an ensemble of multi-class model that uses the less frequent labels.
This is based on the label ignore approach different members of the ensemble.
}
\examples{
model <- esl(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use SVM as base algorithm
model <- esl(toyml, "SVM")
pred <- predict(model, toyml)

# Change the base algorithm and use 4 CORES
model <- esl(toyml[1:50], 'RF', cores = 4, seed = 123)

# Set a parameters for all subproblems
model <- esl(toyml, 'KNN', k=5)
}
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}
}
\concept{Transformation methods}
