## A function to create prediction intervals for linear regression
## Created 20141216 by Brian Williamson

## Args: reg - "uRegress" object, returned by the regress() function
predict.uRegress <- function(object, ...){
  
  ## if reg is not a uRegress object, throw an error
  if(!("uRegress" %in% class(object))){
    stop("uRegress object must be entered")
  }
  if(class(object$fit)=="lm"){
    ret <- predict.lm(object$fit, ...)
  } else if(class(object$fit)[1]=="glm"){
    ret <- predict.glm(object$fit,...)
  } else if (class(object$fit)[1]=="coxph"){
    ret <- predict(object$fit, ...)
  } else {
    stop("Predictions not yet implemented for objects of type 'geeglm'")
  }
  return(ret)
}