#' Make a roses are red poem
#'
#' Make a "roses are red ..." poem
#' about an R package.
#'
#' @param pkg A package
#' @param hint extra information to add to the prompt
#' @param emoji Should the poem include emojis ?
#' @param ... Passed to [openai::create_chat_completion()]
#'
#' @return A poem generated by ChatGPT via [openai::create_chat_completion()]
#'
#' @importFrom glue glue
#' @importFrom openai create_chat_completion
#' @examples
#' prompt("dplyr")
#'
#' \dontrun{
#'   # this needs the OPENAI_API_KEY environment variable
#'   # to be set. See https://irudnyts.github.io/openai/
#'   roses("dplyr")
#' }
#' @export
roses <- function(pkg, hint = "", emoji = TRUE, ...) {
  result <- create_chat_completion(
    model = "gpt-3.5-turbo",
    messages = list(
      list(
        "role" = "system",
        "content" = "You are helpful assistant"
      ),
      list(
        "role" = "user",
        "content" = prompt(pkg, hint, emoji)
      )
    ),
    ...
  )$choices$message.content

  writeLines(result)
  invisible(result)
}

#' @rdname roses
#' @export
prompt <- function(pkg, hint = "", emoji = TRUE) {
  emoji_prompt <- if (isTRUE(emoji)) {
    "Include a bunch of emojis"
  } else {
    "Don't include emojis"
  }
  glue('Make a 4 lines "roses are red ..." poem about the R package "{pkg}". {emoji_prompt}. {hint}')
}
