#' @title Data generated by autoregressive AR9 model.
#'
#' @description
#' Synthetically generated dataset containing values of dependent variable
#' \code{x_t} given values of \cr
#' \code{x_t-1, x_t-2, ..., x_t-15}.
#'
#' @details
#' This dataset was generated using the AR9 model first described in
#' Sharma (2000) and given by:
#'
#' \eqn{x_{t}	= 0.3x_{t-1} - 0.6x_{t-4} - 0.5x_{t-9} + \epsilon_{t}}{%
#'      x_t	= 0.3x_t-1 - 0.6x_t-4 - 0.5x_t-9 + \epsilon_t}
#'
#' where \eqn{\epsilon_{t}}{\epsilon_t}
#'
#' @format A data frame with 1000 rows and 16 variables:
#' \describe{
#'   \item{x_t-1,x_t-2,x_t-3,x_t-4,x_t-5,x_t-6,x_t-7,x_t-8,x_t-9,x_t-10,x_t-11,x_t-12,}{}
#'   \item{x_t-13,x_t-14,x_t-15}{lagged values of
#'     x_t in columns 1:15}
#'   \item{x_t}{dependent variable in column 16}
#' }
#'
#' @references Sharma, A. (2000), Seasonal to interannual rainfall
#' probabilistic forecasts for improved water supply management: Part 1 -
#' a strategy for system predictor identification, Journal of Hydrology,
#' 239(1-4), 232-239, \url{http://dx.doi.org/10.1016/S0022-1694(00)00346-2}.
"ar9"
