% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{compare}
\alias{compare}
\alias{compare,indicator-method}
\alias{compare,validator-method}
\title{Compare similar data sets}
\usage{
compare(x, ...)

\S4method{compare}{validator}(x, ..., .list = NULL, how = c("to_first",
  "sequential"))

\S4method{compare}{indicator}(x, ..., .list = NULL)
}
\arguments{
\item{x}{An R object}

\item{...}{(named) data sets (\emph{e.g.} data.frames)}

\item{.list}{Optional list of data sets, will be concatenated with \code{...}.}

\item{how}{how to compare}
}
\value{
For \code{validator}: An array where each column represents one dataset. The rows count the following
attributes:
\itemize{
\item{Number of validations performed}
\item{Number of validations that evaluate to \code{NA} (unverifiable)}
\item{Number of validations that evaluate to a logical (verifiable)}
\item{Number of validations that evaluate to \code{TRUE}}
\item{Number of validations that evaluate to \code{FALSE}}
\item{Number of extra validations that evaluate to \code{NA} (new, unverifiable)}
\item{Number of validations that still evaluate to \code{NA}}
\item{Number of validations that still evaluate to \code{TRUE}}
\item{Number of extra validations that evaluate to \code{TRUE} }
\item{Number of validations that still evaluate to \code{FALSE}}
\item{Number of extra validations that evaluate to \code{FALSE}}
}

For \code{indicator}: A list with the following components:
\itemize{
\item{\code{numeric}: An array collecting results of scalar indicator (e.g. \code{mean(x)}).}
\item{\code{nonnumeric}: An array collecting results of nonnumeric scalar indicators (e.g. names(which.max(table(x))))}
\item{\code{array}: A list of arrays, collecting results of vector-indicators (e.g. x/mean(x))}
}
}
\description{
Compare different versions of the same dataset with respect to predifined
indicators. Results are simplified in a sensible way.




}
\seealso{
\itemize{
 \item{\code{\link{cells}}}
 \item{\code{\link{validator}}, \code{\link{validator-class}}}
 \item{\code{\link{indicator}}, \code{\link{indicator-class}}}
}
}

