% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmx.R
\name{sdmx_codelist}
\alias{sdmx_codelist}
\alias{estat_codelist}
\alias{global_codelist}
\title{Get code list from an SDMX REST API endpoint.}
\usage{
sdmx_codelist(
  endpoint,
  agency_id,
  resource_id,
  version = "latest",
  what = c("id", "all")
)

estat_codelist(resource_id, agency_id = "ESTAT", version = "latest")

global_codelist(resource_id, agency_id = "SDMX", version = "latest")
}
\arguments{
\item{endpoint}{\code{[character]} REST API endpoint of the SDMX registry}

\item{agency_id}{\code{[character]} Agency ID (e.g. \code{"ESTAT"})}

\item{resource_id}{\code{[character]} Resource ID (e.g. \code{"CL_ACTIVITY"})}

\item{version}{\code{[character]} Version of the code list.}

\item{what}{\code{[character]} Return a \code{character} with code id's, or
a data frame with all information.}
}
\description{
\code{sdmx_codelist} constructs an URL for \code{rsdmx::readSDMX} and
extracts the code IDs.  Code lists are downloaded once and cached for the
duration of the R session.

\code{estat_codelist} gets a code list from the REST API provided at
\code{ec.europa.eu/tools/cspa_services_global/sdmxregistry}. It is a
convenience wrapper that calls \code{sdmx_codelist}.

\code{global_codelist} gets a code list from the REST API provided at
\code{https://registry.sdmx.org/webservice/data.html}.  It is a convenience
wrapper that calls \code{sdmx_codelist}.
}
\examples{
 

 # here we download the CL_ACTIVITY codelist from the  ESTAT registry.
\dontrun{
 codelist <- sdmx_codelist(
   endpoint = "https://registry.sdmx.org/ws/public/sdmxapi/rest/"
   , agency_id = "ESTAT"
   , resource_id = "CL_ACTIVITY" 
}

\dontrun{
  estat_codelist("CL_ACTIVITY")
}
\dontrun{
  global_codelist("CL_AGE") )
  global_codelist("CL_CONF_STATUS")
  global_codelist("CL_SEX")
}
# An example of using SDMX information, downloaded from the SDMX global
# registry
\dontrun{
 # economic data from the country of Samplonia
 data(samplonomy)
 head(samplonomy)

 rules <- validator(
   , freq \%in\% global_codelist("CL_FREQ")
   , value >= 0
 )
 cf <- confront(samplonomy, rules) 
 summary(cf)

}
}
\seealso{
Other sdmx: 
\code{\link{sdmx_endpoint}()},
\code{\link{validator_from_dsd}()}

Other sdmx: 
\code{\link{sdmx_endpoint}()},
\code{\link{validator_from_dsd}()}
}
\concept{sdmx}
