% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_slop.r
\name{bed_slop}
\alias{bed_slop}
\title{Increase the size of input intervals.}
\usage{
bed_slop(x, genome, both = 0, left = 0, right = 0, fraction = FALSE,
  strand = FALSE, trim = FALSE, ...)
}
\arguments{
\item{x}{tbl of intervals}

\item{genome}{tbl of chrom sizes}

\item{both}{number of bases on both sizes}

\item{left}{number of bases on left side}

\item{right}{number of bases on right side}

\item{fraction}{define flanks based on fraction of interval length}

\item{strand}{define \code{left} and \code{right} based on strand}

\item{trim}{adjust coordinates for out-of-bounds intervals}

\item{...}{extra arguments (not used)}
}
\value{
\code{data_frame}
}
\description{
Increase the size of input intervals.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',      110,      120,
  'chr1',      225,     235
  )
  
genome <- tibble::tribble(
  ~chrom, ~size,
  'chr1',      400
)

bed_glyph(bed_slop(x, genome, both = 20, trim = TRUE))

genome <- tibble::tribble(
 ~chrom, ~size,
 "chr1", 5000
)

x <- tibble::tribble(
 ~chrom, ~start, ~end, ~name, ~score, ~strand,
 "chr1", 500,    1000, '.',   '.',     '+',
 "chr1", 1000,   1500, '.',   '.',     '-'
)

bed_slop(x, genome, left = 100)

bed_slop(x, genome, right = 100)

bed_slop(x, genome, both = 100)

bed_slop(x, genome, both = 0.5, fraction = TRUE)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/slop.html}

Other single-set-ops: \code{\link{bed_cluster}},
  \code{\link{bed_complement}}, \code{\link{bed_flank}},
  \code{\link{bed_merge}}, \code{\link{bed_random}},
  \code{\link{bed_shift}}, \code{\link{bed_shuffle}}
}
