% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theorical_comparison.R
\name{density_plot_theorical}
\alias{density_plot_theorical}
\title{density_plot_theorical}
\usage{
density_plot_theorical(
  value_sets_3L = NULL,
  value_sets_5L = NULL,
  value_sets_XW = NULL,
  value_sets_XWR = NULL,
  value_sets_others = NULL,
  graph_title = "",
  x_axis_title = "Index Value",
  x_min_value = NULL,
  x_max_value = NULL,
  y_axis_title = "Density",
  y_min_value = NULL,
  y_max_value = NULL,
  legend_name = "",
  color_palette = NULL,
  line_types = NULL
)
}
\arguments{
\item{value_sets_3L}{A character vector specifying the country value sets for the EQ5D-3L version.}

\item{value_sets_5L}{A character vector specifying the country value sets for the EQ5D-5L version.}

\item{value_sets_XW}{A character vector specifying the country value sets for the EQ5D-XW version.}

\item{value_sets_XWR}{A character vector specifying the country value sets for the EQ5D-XWR version.}

\item{value_sets_others}{A list of lists specifying the inputs for other instruments. Each list within the main list should be named and contain a data frame (`df`), a column specifying the health states (`stateColumn`), and a column specifying the utility values (`utilityColumn`).}

\item{graph_title}{A character string specifying the title of the graph. Default is an empty string.}

\item{x_axis_title}{A character string specifying the title of the x-axis. Default is "Index Value".}

\item{x_min_value}{A numeric specifying the minimum value for the x-axis. Default is NULL.}

\item{x_max_value}{A numeric specifying the maximum value for the x-axis. Default is NULL.}

\item{y_axis_title}{A character string specifying the title of the y-axis. Default is "Density".}

\item{y_min_value}{A numeric specifying the minimum value for the y-axis. Default is NULL.}

\item{y_max_value}{A numeric specifying the maximum value for the y-axis. Default is NULL.}

\item{legend_name}{A character string specifying the name of the legend. Default is "".}

\item{color_palette}{A character vector specifying the colors for the density lines. Default is a predefined color palette.}

\item{line_types}{A character vector specifying the line types for the density lines. Default is solid.}
}
\value{
A ggplot object visualizing the density of utilities for the specified EQ5D versions and other instruments value sets.
}
\description{
This function creates a smoothed kernel density plot of utilities for different EQ5D versions and specified value sets.
}
\examples{
density_plot_theorical(value_sets_3L = "NL", value_sets_5L = "NL")
instrument <- data.frame(HS=c(123, 456, 789), val = c(-0.3, 0.1, 0.75))
value_set_other <- list(test_instrument = list(df = instrument, 
                        stateColumn = "HS", 
                        utilityColumn = "val"))
density_plot_theorical(value_sets_3L = "HU", value_sets_others = value_set_other)
}
