% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payoffs.R
\docType{class}
\name{payoff_ratchet}
\alias{payoff_ratchet}
\title{Ratchet payoff class}
\format{\code{\link{R6Class}} object.}
\usage{
payoff_ratchet
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class providing a ratchet payoff object.
The payoff will be the highest account value recorded at
some specified times.
}
\section{Methods}{

 \describe{
  \item{\code{new}}{Initialize method.
   The arguments are a non negative scalar with the premium and the
   ratchet frequency. Allowed units for the frequency are "m" for
    4 weeks, "w" for weeks, "d" for days}
  \item{\code{set_premium}}{Stores the premium in a
   private field. The argument is a non negative scalar}
  \item{\code{get_premium}}{Returns the premium
   as non negative scalar}
  \item{\code{set_freq}}{Sets the ratchet frequency.
   Allowed units for the frequency are "m" for
   4 weeks, "w" for weeks, "d" for days}
  \item{\code{get_payoff}}{Gets the payoff.
   The arguments are a \code{numeric} vector
   with the amounts, a vector of \code{\link{timeDate}} objects
   with the start and end dates for the ratchet and a \code{numeric}
   vector with the account values. (see \bold{Examples})}
}
}

\examples{
freq <- "1m"
premium <- 100
ratchet <- payoff_ratchet$new(premium, freq)
t1 <- timeDate::timeDate("2016-01-01")
t2 <- timeDate::timeDate("2016-12-31")
account <- 120 * rnorm(365)
ratchet$get_payoff(c(120,100), c(t1,t2), account)
}
\keyword{datasets}
