% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{aaStandardizeNames}
\alias{aaStandardizeNames}
\title{Standardize Amino Acid Names}
\usage{
aaStandardizeNames(residue.names)
}
\arguments{
\item{residue.names}{A vector of strings containing the three-letter residue
names (strings)}
}
\value{
vector of \emph{standardized} amino acid residue names
}
\description{
Standardize the various three-letter amino acid residue names.
}
\details{
The various three-letter amino acid residue names used to indicate
protonation state or uncommon sidechain bonding (ligatation) are converted
to the standard amino acid residue name.
}
\examples{
  residue.names <- c("HIS", "HID", "HIE", "HIP", "HSD", "HSE", "HSP",
                     "CYS", "CYM", "CYX", "ASP", "ASH", "GLU", "GLH",
                     "LYS", "LYN")
  aaStandardizeNames(residue.names)
  # [1] "HIS" "HIS" "HIS" "HIS" "HIS" "HIS" "HIS" "CYS" "CYS" "CYS"
  #     "ASP" "ASP" "GLU" "GLU" "LYS" "LYS"

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
