% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{resAtomType2AtomClass}
\alias{resAtomType2AtomClass}
\title{Convert Residue-AtomType to AtomType Class}
\usage{
resAtomType2AtomClass(resAT)
}
\arguments{
\item{resAT}{residue and AtomType; \emph{e.g.}, \code{"LYS NZ"}}
}
\value{
A string with the AtomType's class:
\itemize{
\item Nitrogen
\item Nitrogen (+)
\item Oxygen
\item Oxygen (-)
\item Carbon
\item Sulfur
}
}
\description{
Converts the residue-AtomType to AtomType Class.
}
\details{
See examples...
}
\examples{
  resAtomType2AtomClass(resAT="LYS NZ")
  # [1] "Nitrogen (+)"
  resAtomType2AtomClass(resAT="GLU N")
  # [1] "Nitrogen"
  resAtomType2AtomClass(resAT="VAL O")
  # [1] "Oxygen"
  resAtomType2AtomClass(resAT="ASP OD2")
  # [1] "Oxygen (-)"
  resAtomType2AtomClass(resAT="GLN CA")
  # [1] "Carbon"
  resAtomType2AtomClass(resAT="CYS SG")
  # [1] "Sulfur"

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
