% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-package.R
\docType{package}
\name{vapour-package}
\alias{vapour-package}
\alias{vapour}
\title{vapour}
\description{
A lightweight GDAL API package for R.
}
\details{
Provides low-level access to 'GDAL' functionality for R packages. The aim is
to minimize the level of interpretation put on the 'GDAL' facilities, to
enable direct use of it for a variety of purposes. 'GDAL' is the 'Geospatial
Data Abstraction Library' a translator for raster and vector geospatial data
formats that presents a single raster abstract data model and single vector
abstract data model to the calling application for all supported formats
\url{https://gdal.org/}.

Lightweight means we access parts of the GDAL API as near as possible to
their native usage. GDAL is not a lightweight library, but provide a very
nice abstraction over format details for a very large number of different
formats.

Functions for raster and vector sources are included.

\tabular{ll}{ \code{\link{vapour_all_drivers}}         \tab list of all
available drivers, with type and features \cr \code{\link{vapour_driver}}
\tab report short name of driver that will be used for a data source \cr
\code{\link{vapour_gdal_version}}        \tab report version of GDAL in use
\cr \code{\link{vapour_srs_wkt}}        \tab produce WKT projection string
from various projection string inputs \cr \code{\link{vapour_vsi_list}}
\tab report contents of VSI sources \cr

}

\tabular{ll}{ \code{\link{vapour_raster_gcp}}        \tab return internal
ground control points, if present \cr \code{\link{vapour_raster_info}}
\tab structural metadata of a source \cr \code{\link{vapour_read_raster}}
\tab read data direct from a window of a raster band source \cr
\code{\link{vapour_sds_names}}          \tab list individual raster sources
in a source containing subdatasets \cr \code{\link{vapour_warp_raster}}  \tab
read data direct from a raster source into a specific window \cr }

\tabular{ll}{ \code{\link{vapour_driver}}             \tab report name of the
driver used for a given source \cr \code{\link{vapour_geom_name}}       \tab
report attribute name of geometry \cr \code{\link{vapour_geom_summary}}
\tab report simple properties of each feature geometry \cr
\code{\link{vapour_layer_names}}        \tab list names of vector layers in a
data source \cr \code{\link{vapour_layer_info}} \tab list of data source,
driver, layer name/s, fields, feature count, projection \cr
\code{\link{vapour_read_extent}}        \tab read the extent, or bounding
box, of geometries in a layer \cr \code{\link{vapour_read_fields}}    \tab
read attributes of features in a layer, the columnar data associated with
each geometry \cr \code{\link{vapour_read_geometry}}      \tab read geometry
in binary (blob, WKB) form \cr \code{\link{vapour_read_geometry_ia}} \tab
read geometry by index, arbitrary \cr \code{\link{vapour_read_geometry_ij}}
\tab read geometry by sequential index, i to j \cr
\code{\link{vapour_read_geometry_text}} \tab read geometry in text form,
various formats \cr \code{\link{vapour_read_names}}         \tab read the
'names' of features in a layer, the 'FID' \cr \code{\link{vapour_read_type}}
\tab read the GDAL types of attributes \cr \code{\link{vapour_report_fields}}
\tab report internal type of each attribute by name \cr }

As far as possible vapour aims to minimize the level of interpretation
provided for the functions, so that developers can choose how things are
implemented. Functions return raw lists or vectors rather than data frames or
classed types.
}
\section{options}{


The following options can be set to control global behaviour.

\tabular{ll}{ \code{Sys.getenv("vapour.sql.dialect")} \tab the current SQL
dialect in use \cr }
}

\section{SQL dialect}{


The SQL dialect can be set to "" (empty string), "OGRSQL", or "SQLITE".

The empty string indicates that the native dialect will be used, see
\href{https://gdal.org/user/ogr_sql_sqlite_dialect.html}{OGRSQL and SQLITE for GDAL, accessed 2022-11-11} and the
\href{https://gdal.org/api/raster_c_api.html#c.GDAL_DMD_SUPPORTED_SQL_DIALECTS}{GDAL_DMD_SUPPORTED_SQL_DIALECTS development documentation (since GDAL 3.6)}.

Setting "NATIVE" as an alias for "" is quite recent and has not been tested with vapour, similarly no testing has been done
with non OGRSQL-native or SQLITE-native drivers yet.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hypertidy/vapour}
  \item \url{https://hypertidy.github.io/vapour/}
  \item Report bugs at \url{https://github.com/hypertidy/vapour/issues}
}

}
\author{
\strong{Maintainer}: Michael Sumner \email{mdsumner@gmail.com} (\href{https://orcid.org/0000-0002-2471-7511}{ORCID})

Other contributors:
\itemize{
  \item Simon Wotherspoon (RasterIO configuration for resampling options) [contributor]
  \item Mark Padgham (helped get started :)) [contributor]
  \item Edzer Pebesma (wrote the field-read handling, adapted here from sf) [contributor]
  \item Roger Bivand (wrote configure.ac, adapted here from rgdal) [contributor]
  \item Jim Hester (wrote CollectorList.h, copied here from fs package) [contributor, copyright holder]
  \item Timothy Keitt (wrote GetPointsInternal copied here from rgdal2 package) [contributor]
  \item Jeroen Ooms (tweaked build process, provided Windows build tools) [contributor]
  \item Dale Maschette (created the hex logo) [contributor]
  \item Joseph Stachelek [contributor]
  \item Even Rouault (primary author of the COG format and its use of the GDALwarp app-library, example code used by the warper function here) [contributor]
  \item Robert Hijmans (code in terra package used as example/inspiration) [contributor]
  \item Dewey Dunnington (wrote the columnar-access mode streaming Arrow support) [contributor]
  \item Tomas Kalibera [contributor]
}

}
