% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-package.R
\docType{package}
\name{vapour-package}
\alias{vapour-package}
\alias{vapour}
\title{vapour}
\description{
A lightweight GDAL API package for R.
}
\details{
Provides low-level access to 'GDAL' functionality for R packages. The aim is
to minimize the level of interpretation put on the 'GDAL' facilities, to
enable direct use of it for a variety of purposes. 'GDAL' is the 'Geospatial
Data Abstraction Library' a translator for raster and vector geospatial data
formats that presents a single raster abstract data model and single vector
abstract data model to the calling application for all supported formats
\url{https://gdal.org/}.

Lightweight means we access parts of the GDAL API as near as possible to
their native usage. GDAL is not a lightweight library, but provide a very
nice abstraction over format details for a very large number of different
formats.

Functions for raster and vector sources are included.

#' \tabular{ll}{
\code{\link{vapour_all_drivers}}         \tab list of all available drivers, with type and features \cr
\code{\link{vapour_gdal_version}}        \tab report version of GDAL in use \cr
}

\tabular{ll}{
\code{\link{vapour_raster_gcp}}        \tab return internal ground control points, if present \cr
\code{\link{vapour_raster_info}}        \tab structural metadata of a source \cr
\code{\link{vapour_read_raster}}        \tab read data direct from a window of a raster band source \cr
\code{\link{vapour_sds_names}}          \tab list individual raster sources in a source containing subdatasets \cr
}

\tabular{ll}{
\code{\link{vapour_driver}}             \tab report name of the driver used for a given source \cr
\code{\link{vapour_geom_summary}}       \tab report simple properties of each feature geometry \cr
\code{\link{vapour_layer_names}}        \tab list names of vector layers in a data source \cr
\code{\link{vapour_read_names}}         \tab read the 'names' of features in a layer, the 'FID' \cr
\code{\link{vapour_read_attributes}}    \tab read attributes of features in a layer, the columnar data associated with each geometry \cr
\code{\link{vapour_read_extent}}        \tab read the extent, or bounding box, of geometries in a layer \cr
\code{\link{vapour_read_geometry}}      \tab read geometry in binary (blob, WKB) form \cr
\code{\link{vapour_read_geometry_text}} \tab read geometry in text form, various formats \cr
\code{\link{vapour_report_attributes}}  \tab report internal type of each attribute by name \cr
}

As far as possible vapour aims to minimize the level of interpretation
provided for the functions, so that developers can choose how things are
implemented. Functions return raw lists or vectors rather than data frames
or classed types.
}
