% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_attributes.R
\name{vapour_report_attributes}
\alias{vapour_report_attributes}
\title{Read feature field attributes types.}
\usage{
vapour_report_attributes(dsource, layer = 0L, sql = "")
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}
}
\description{
Obtains the internal type-constant name for the data attributes in a source.
Use this to compare the interpreted versions converted into R types by
\code{vapour_read_attributes}.
}
\details{
These are defined for the enum OGRFieldType in GDAL itself.
\url{https://gdal.org/doxygen/ogr__core_8h.html#a787194bea637faf12d61643124a7c9fc}
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
vapour_report_attributes(mvfile)

## modified by sql argument
vapour_report_attributes(mvfile,
  sql = "SELECT POSTCODE, NAME FROM list_locality_postcode_meander_valley")
}
