% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_read_block.R
\name{vapour_read_raster_block}
\alias{vapour_read_raster_block}
\title{Read or write raster block}
\usage{
vapour_read_raster_block(
  dsource,
  offset,
  dimension,
  band = 1L,
  band_output_type = ""
)
}
\arguments{
\item{dsource}{file name to read from, or write to}

\item{offset}{position x,y to start writing (0-based, y-top)}

\item{dimension}{window size to read from, or write to}

\item{band}{which band to read (1-based)}

\item{band_output_type}{numeric type of band to apply (else the native type if '') can be one of 'Byte', 'Int32', or 'Float64'}
}
\value{
a list with a vector of data from the band read
}
\description{
Read a 'block' from raster.
}
\examples{
f <- system.file("extdata", "sst.tif", package = "vapour")
v <- vapour_read_raster_block(f, c(0L, 0L), dimension = c(2L, 3L), band = 1L)
}
